// UParser.cp
// UParser.h
// ----------------------------------------------------------------------------------
// Word to Phoneme parser for the Spell checker.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// This is from a lex compilier.  It is a subclass of UPhoneMatch and match phonemes.
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Made UPhoneMatch a contained object.  Before UPhoneMatch (actually under
//			a different name) was the superclass of UParser.
// ----------------------------------------------------------------------------------


#ifndef __RULES_
#define __RULES_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "USound.h"
#include "UPhnMch.h"
#include "UError.h"

#define MAXREGEXPATTERNLENGTH (2048)

#define ON    (1)
#define OFF   (0)

// ----------------------------------------------------------------------------------
// LEX defines
// ----------------------------------------------------------------------------------

#define YY_DEFAULT_ACTION {}; // WAS ECHO;

#define YY_END_TOK 0
#define YY_NEW_FILE -1
#define YY_DO_DEFAULT -2
#ifndef BUFSIZ
#include <stdio.h>
#endif
#define F_BUFSIZ 128
#define YY_BUF_SIZE (F_BUFSIZ * 2)
#define YY_BUF_MAX (YY_BUF_SIZE - 1)
#ifndef YY_MAX_LINE
#define YY_MAX_LINE F_BUFSIZ
#endif
#define YY_BUF_LIM (YY_BUF_MAX - YY_MAX_LINE)

// Note: this is redefined from the lex output
#define YY_INPUT(b,r,ms) (r=InputWord(b,ms))


#define YY_NULL 0
#define YY_FATAL_ERROR() \
	{ \
		ErrorFunc(eUser_Dict_Corrupted, SET); \
	}
#define YY_FIRST_CHAR yy_ch_buf[yy_b_buf_p]
#define yywrap() 1
#define BEGIN yy_start = 1 +
#define YY_SET_BOL(array,pos) array[pos - 1] = '\n';
#define YY_DECL short yylex()
#define yyless(n) \
	{ \
	YY_DO_BEFORE_SCAN; \
	yy_c_buf_p = yy_b_buf_p + (n) - 1; \
	YY_DO_BEFORE_ACTION; \
	}
#define YY_BREAK break;
#define YY_INIT \
	{ \
	yyleng = yy_c_buf_p = yy_e_buf_p = 0; \
	yy_hold_char = yy_ch_buf[yy_c_buf_p] = '\n'; \
	yytext = &yy_ch_buf[yy_c_buf_p]; \
	yy_saw_eof = 0; \
	}
#define YY_LENG (yy_c_buf_p - yy_b_buf_p + 1)
#define YY_DO_BEFORE_SCAN \
	yytext[yyleng] = yy_hold_char;
#define YY_DO_BEFORE_ACTION \
	yytext = &yy_ch_buf[yy_b_buf_p]; \
	yyleng = YY_LENG; \
	yy_hold_char = yytext[yyleng]; \
	yytext[yyleng] = '\0';
#define REJECT \
	{ \
	YY_DO_BEFORE_SCAN; \
	yy_c_buf_p = yy_full_match; \
	++yy_lp; \
	goto find_rule; \
	}


#define __INITIAL 0



//#define TRACE


#define min(a,b)    (((a) < (b)) ? (a) : (b))
#undef YYDECL
#define YYDECL short UParser::yylex()



#define NORMAL 2
#define VOWEL 4
#define INITIAL 6
  // duplicates
#define YY_JAM 200
#define YY_JAM_BASE 970



class UParser:UPhoneMatch {
	friend	class UPhoneMatch;
public:
	UParser();
	~UParser();
	
	void CreatePhonPattern(char *Word);
	short  PhonTestWord(char *Word);
	short  InitialPhoneme;

private:

	short TestWord;
	short PhonemePosition;
	short   WordPosition;  // used in InputWord() and NewWord()
	short   WordLength;    // used in InputWord() and NewWord()
	char *WordPointer;   // used in InputWord() and NewWord()
	
	/* ABRAXAS LEX / LEX FUNCTIONS */
	short  InputWord(char *Buf, short MaxSize);
	void unput(char c);
	void NewWord(char *Word);
	short  yylex();
	short  input(void);
	

	short  B();
	short  CH();
	short  D();
	short  F();
	short  G();
	short  H();
	short  J();
	short  K();
	short  L();
	short  M();
	short  N();
	short  P();
	short  R();
	short  S();
	short  SH();
	short  T();
	short  TS();
	short  V();
	short  W();
	short  Z();
	short  V1();
	short  Ve();
	short  Vet();
	short  EOW();
	
	short *a;
	short  	*l;
	short  *b;
	short  *d;
	short  *n;
	short  *c;
	short yy_start, yy_b_buf_p, yy_c_buf_p, yy_e_buf_p;
	short yy_saw_eof, yy_init;
	char yy_ch_buf[YY_BUF_SIZE + 1];
	short yy_st_buf[YY_BUF_SIZE];
	char yy_hold_char;
	char *yytext;
	short yyleng;

}; // UParser

#endif

